<?php
require_once 'includes/functions.php';
checkAuth();
include 'includes/header.php';
?>

<div class="sales-view">
    <div class="view-header">
        <h1 class="gold-gradient-text">Historial de Ventas</h1>
    </div>

    <div class="sales-table-container glass-card" style="padding: 20px;">
        <table style="width: 100%; border-collapse: collapse; color: white;">
            <thead>
                <tr style="border-bottom: 1px solid var(--glass-border); text-align: left;">
                    <th style="padding: 10px;">ID</th>
                    <th style="padding: 10px;">Fecha</th>
                    <th style="padding: 10px;">Vendedor</th>
                    <th style="padding: 10px;">Tipo</th>
                    <th style="padding: 10px;">Método</th>
                    <th style="padding: 10px;">Total</th>
                    <th style="padding: 10px;">Acciones</th>
                </tr>
            </thead>
            <tbody id="salesTableBody">
                <!-- Sales loaded here -->
            </tbody>
        </table>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', loadSales);

    async function loadSales() {
        try {
            const res = await fetch('api/sales.php');
            const result = await res.json();

            if (result.success) {
                const tbody = document.getElementById('salesTableBody');
                tbody.innerHTML = '';

                result.data.forEach(sale => {
                    const tr = document.createElement('tr');
                    tr.style.borderBottom = '1px solid rgba(255,255,255,0.05)';
                    tr.innerHTML = `
                        <td style="padding: 10px;">#${sale.id}</td>
                        <td style="padding: 10px;">${new Date(sale.created_at).toLocaleDateString()} ${new Date(sale.created_at).toLocaleTimeString()}</td>
                        <td style="padding: 10px;">${sale.seller_name}</td>
                        <td style="padding: 10px;">${sale.type}</td>
                        <td style="padding: 10px;">${sale.payment_method || '-'}</td>
                        <td style="padding: 10px; font-weight: bold; color: var(--gold-primary);">$${parseFloat(sale.total).toFixed(2)}</td>
                        <td style="padding: 10px;">
                            <button onclick='alert("Detalles: " + JSON.stringify(${JSON.stringify(sale.items)}))' style="padding: 5px 10px; background: var(--black-border); border: none; border-radius: 4px; color: white; cursor: pointer;">
                                <i data-lucide="eye" size="16"></i>
                            </button>
                        </td>
                    `;
                    tbody.appendChild(tr);
                });
                lucide.createIcons();
            }
        } catch (e) {
            console.error(e);
        }
    }
</script>

<?php include 'includes/footer.php'; ?>