<?php
$currentPage = basename($_SERVER['PHP_SELF']);
$userInitial = isset($_SESSION['name']) ? substr($_SESSION['name'], 0, 1) : 'U';
?>
<div class="sidebar-overlay" id="sidebarOverlay"></div>
<aside class="sidebar glass-card" id="sidebar">
    <div class="sidebar-header">
        <h2 className="gold-gradient-text">URBAN CAPS</h2>
        <button class="mobile-close" id="sidebarClose">
            <i data-lucide="x"></i>
        </button>
    </div>

    <div className="user-info">
        <div className="avatar">
            <?php echo $userInitial; ?>
        </div>
        <div className="details">
            <p className="name">
                <?php echo $_SESSION['name'] ?? 'User'; ?>
            </p>
            <p className="role">
                <?php echo $_SESSION['role'] ?? 'Role'; ?>
            </p>
        </div>
    </div>

    <nav className="sidebar-nav">
        <a href="dashboard.php" class="nav-link <?php echo $currentPage == 'dashboard.php' ? 'active' : ''; ?>">
            <span class="icon"><i data-lucide="layout-dashboard"></i></span>
            <span class="label">Dashboard</span>
        </a>
        <a href="inventory.php" class="nav-link <?php echo $currentPage == 'inventory.php' ? 'active' : ''; ?>">
            <span class="icon"><i data-lucide="package"></i></span>
            <span class="label">Inventario</span>
        </a>
        <a href="pos.php" class="nav-link <?php echo $currentPage == 'pos.php' ? 'active' : ''; ?>">
            <span class="icon"><i data-lucide="shopping-cart"></i></span>
            <span class="label">Nueva Venta</span>
        </a>
        <a href="sales.php" class="nav-link <?php echo $currentPage == 'sales.php' ? 'active' : ''; ?>">
            <span class="icon"><i data-lucide="history"></i></span>
            <span class="label">Historial</span>
        </a>
        <a href="reservations.php" class="nav-link <?php echo $currentPage == 'reservations.php' ? 'active' : ''; ?>">
            <span class="icon"><i data-lucide="calendar-clock"></i></span>
            <span class="label">Reservas</span>
        </a>
    </nav>

    <div className="sidebar-footer">
        <a href="logout.php" class="logout-btn">
            <i data-lucide="log-out"></i>
            <span>Cerrar Sesión</span>
        </a>
    </div>
</aside>

<script>
    // Sidebar toggle logic might be needed in header or main js
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    const closeBtn = document.getElementById('sidebarClose');

    // Toggle function to be called from header button
    function toggleSidebar() {
        sidebar.classList.toggle('open');
        overlay.classList.toggle('show');
    }

    if (closeBtn) closeBtn.addEventListener('click', toggleSidebar);
    if (overlay) overlay.addEventListener('click', toggleSidebar);
</script>