<?php
require_once '../config/db.php';
require_once '../includes/functions.php';

checkAuth();

try {
    // Total Revenue
    $stmt = $pdo->query("SELECT SUM(total) as total FROM sales WHERE status = 'COMPLETED'");
    $totalRevenue = $stmt->fetchColumn() ?: 0;

    // Total Stock and Product Count
    $stmt = $pdo->query("SELECT SUM(stock) as totalStock, COUNT(*) as count FROM products");
    $stockData = $stmt->fetch();
    $totalStock = $stockData['totalStock'] ?: 0;
    $productsCount = $stockData['count'];

    // Low Stock Count
    $stmt = $pdo->query("SELECT COUNT(*) FROM products WHERE stock < 5");
    $lowStockCount = $stmt->fetchColumn();

    jsonResponse(true, [
        'totalRevenue' => round((float) $totalRevenue, 2),
        'totalStock' => (int) $totalStock,
        'lowStockCount' => (int) $lowStockCount,
        'productsCount' => (int) $productsCount
    ]);

} catch (PDOException $e) {
    jsonResponse(false, [], $e->getMessage());
}
?>